;common routines and variable declarations

;kernal calls

talk			= $ffb4
tksa			= $ff96
untlk			= $ffab
acptr			= $ffa5
ciout			= $ffa8
open			= $ffc0
close			= $ffc3
listen			= $ffb1
unlsn			= $ffae
second			= $ff93
chkin			= $ffc6
chkout			= $ffc9
clrchn			= $ffcc
chrin			= $ffcf
chrout			= $ffd2
getin			= $ffe4
clall			= $ffe7
setlfs			= $ffba
setnam			= $ffbd
load			= $ffd5
save			= $ffd8

printoriginlow		= $02
printoriginhigh		= $03
printdestinationlow	= $04
printdestinationhigh	= $05
printcolor		= $06
printcolorlow		= $07
printcolorhigh		= $08

fillstartlow		= $09
fillstarthigh		= $0a
fillendlow		= $0b
fillendhigh		= $0c
fillbyte		= $0d

loadstart		= $2b
loadend			= $2d
loadaddress		= $ae
st			= $90

;wait for space bar

waitspace	.proc

	lda #$ef
waitspc
	cmp $dc01
	bne waitspc
	rts
		.pend

;$01 manipulations

basicout	.proc

	lda $01
	and #$fe
	sta $01
	rts
		.pend
basicin		.proc
	lda $01
	ora #$01
	sta $01
	rts
		.pend
romsout		.proc
	lda $01
	and #$fd
	sta $01
	rts
		.pend
romsin		.proc
	lda $01
	ora #$02
	sta $01
	rts
		.pend
allout		.proc
	lda $01
	and #$fc
	sta $01
	rts
		.pend
allin		.proc
	lda $01
	ora #$03
	sta $01
	rts
		.pend
;number conversions

;hex 2 decimal
;call with value in a
;return y = hundreds, x = tens, a = ones

hex2dec		.proc

	ldy #$2f
	ldx #$3a
	sec

h2dloop1

	iny
	sbc #$64
	bcs h2dloop1

h2dloop2

	dex
	adc #$0a
	bmi h2dloop2
	adc #$2f
	rts
		.pend
;hex 2 petscii
;call with value in a
;return y = high nybbel, a = low nybbel


hex2pet		.proc

	tax
	lsr
	lsr
	lsr
	lsr
	jsr h2phigh
	tay
	txa
	and #$0f
h2phigh
	ora #$30
	cmp #$3a
	bcc h2pexit
	adc #$06
h2pexit
	rts
		.pend

;print message

;call with pha destinationlow, pha destinationhigh, x = originlow, y = originhigh, a = color  
;

printmessage	.proc

	sta printcolor
	stx printoriginlow
	sty printoriginhigh
	pla
	tax
	pla
	tay
	pla
	sta printdestinationhigh
	clc
	adc #$d4
	sta printcolorhigh
	pla
	sta printdestinationlow
	sta printcolorlow
	tya
	pha
	txa
	pha
	ldy #$00

printloop

	lda (printoriginlow),y
	beq printdone
	sta (printdestinationlow),y
	lda printcolor
	sta (printcolorlow),y

	inc printoriginlow
	bne printskip1
	inc printoriginhigh

printskip1

	inc printdestinationlow
	inc printcolorlow
	bne printskip2
	inc printdestinationhigh
	inc printcolorhigh

printskip2

	jmp printloop

printdone
	rts
		.pend

;memory fill
;call with pha startaddresslow, pha startaddresshigh, x = endaddresslow, y = endaddresshigh, a = fillbyte


fillmemory	.proc

	sta fillbyte
	stx fillendlow
	sty fillendhigh
	pla
	tax
	pla
	tay
	pla
	sta fillstarthigh
	pla
	sta fillstartlow
	tya
	pha
	txa
	pha
	ldy #$00

fillloop

	lda fillbyte
	sta (fillstartlow),y
	inc fillstartlow
	bne fillskip
	inc fillstarthigh

fillskip
	lda fillstarthigh
	cmp fillendhigh
	bne fillloop
	lda fillstartlow
	cmp fillendlow
	bne fillloop
	rts
		.pend

;clear screen

;call with a = color memory color, x = border color, y = background color

clearscreen	.proc

	sta printcolor
	stx $d020
	sty $d021
	ldx #$00

clearloop

	lda #$20
	sta $0400,x
	sta $0500,x
	sta $0600,x
	sta $0700,x
	lda printcolor
	sta $d800,x
	sta $d900,x
	sta $da00,x
	sta $db00,x
	inx
	bne clearloop
	rts
		.pend